<?php
/**
 * Plugin Name: حداقل مبلغ سفارش در ووکامرس
 * Plugin URI:  https://codegate.ir/
 * Description: تعیین حداقل مبلغ سبد خرید (بدون هزینه ارسال) و جلوگیری از پرداخت اگر مبلغ کمتر از حد مجاز باشد.
 * Version:     1.0
 * Author:      Saeed gharibi
 * License:     GPL2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 1. افزودن فیلد تنظیمات به بخش تنظیمات ووکامرس
add_filter( 'woocommerce_get_sections_general', 'wcmo_add_settings_section' );
function wcmo_add_settings_section( $sections ) {
    $sections['wcmo'] = __( 'حداقل مبلغ سفارش', 'wcmo' );
    return $sections;
}

add_filter( 'woocommerce_get_settings_general', 'wcmo_add_settings', 10, 2 );
function wcmo_add_settings( $settings, $current_section ) {
    if ( 'wcmo' === $current_section ) {
        $settings = array();

        $settings[] = array(
            'name' => __( 'تنظیمات حداقل مبلغ سفارش', 'wcmo' ),
            'type' => 'title',
            'id'   => 'wcmo_settings_title'
        );

        $settings[] = array(
            'name'     => __( 'حداقل مبلغ سبد خرید', 'wcmo' ),
            'id'       => 'wcmo_minimum_amount',
            'type'     => 'number',
            'desc_tip' => __( 'مبلغ حداقل سفارش (بدون احتساب هزینه ارسال) را وارد کنید.', 'wcmo' ),
            'default'  => 50,
            'desc'     => __( 'مثال: اگر مقدار را 50 وارد کنید، کاربران باید حداقل ۵۰ واحد پولی خرید داشته باشند تا بتوانند پرداخت کنند.', 'wcmo' ),
        );

        $settings[] = array( 'type' => 'sectionend', 'id' => 'wcmo_settings_end' );
        return $settings;
    }
    return $settings;
}

// 2. بررسی مبلغ سبد خرید قبل از پرداخت
add_action( 'woocommerce_checkout_process', 'wcmo_check_minimum_order' );
add_action( 'woocommerce_before_cart', 'wcmo_check_minimum_order' );

function wcmo_check_minimum_order() {
    $minimum = get_option( 'wcmo_minimum_amount', 50 );
    $cart_subtotal = WC()->cart->get_subtotal();

    if ( $cart_subtotal < $minimum ) {
        $message = sprintf(
            __( 'مبلغ فعلی سبد خرید شما %s است — حداقل مبلغ مورد نیاز برای پرداخت %s می‌باشد.', 'wcmo' ),
            wc_price( $cart_subtotal ),
            wc_price( $minimum )
        );
        if ( is_cart() ) {
            wc_print_notice( $message, 'error' );
        } else {
            wc_add_notice( $message, 'error' );
        }
    }
}
